/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.block;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ChestBlock;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.ItemStackTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import svenhjol.charm.base.CharmModule;
import svenhjol.charm.base.block.ICharmBlock;
import svenhjol.charm.base.enums.IVariantMaterial;
import svenhjol.charm.block.IVariantChestBlock;
import svenhjol.charm.module.VariantChests;
import svenhjol.charm.tileentity.VariantTrappedChestTileEntity;

public class VariantTrappedChestBlock
extends ChestBlock
implements ICharmBlock,
IVariantChestBlock {
    private final CharmModule module;
    private final IVariantMaterial type;

    public VariantTrappedChestBlock(CharmModule module, IVariantMaterial type) {
        super(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150447_bR), () -> VariantChests.TRAPPED_BLOCK_ENTITY);
        this.module = module;
        this.type = type;
        this.register(module, type.func_176610_l() + "_trapped_chest");
    }

    @Override
    public ItemGroup getItemGroup() {
        return ItemGroup.field_78028_d;
    }

    public void func_149666_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.enabled()) {
            super.func_149666_a(group, items);
        }
    }

    @Override
    public boolean enabled() {
        return this.module.enabled;
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        VariantTrappedChestTileEntity chest = new VariantTrappedChestTileEntity();
        chest.func_213903_a((ITextComponent)new TranslationTextComponent("block." + this.module.mod + "." + this.type.func_176610_l() + "_trapped_chest"));
        return chest;
    }

    public int func_180656_a(BlockState state, IBlockReader world, BlockPos pos, Direction direction) {
        return MathHelper.func_76125_a((int)ChestTileEntity.func_195481_a((IBlockReader)world, (BlockPos)pos), (int)0, (int)15);
    }

    public int func_176211_b(BlockState state, IBlockReader world, BlockPos pos, Direction direction) {
        return direction == Direction.UP ? state.func_185911_a(world, pos, direction) : 0;
    }

    @Override
    public IVariantMaterial getMaterialType() {
        return this.type;
    }

    public boolean func_149744_f(BlockState state) {
        return true;
    }

    protected Stat<ResourceLocation> func_196310_d() {
        return Stats.field_199092_j.func_199076_b((Object)Stats.field_188089_W);
    }

    @Override
    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public Supplier<Callable<ItemStackTileEntityRenderer>> getISTER() {
        return () -> () -> new ItemStackTileEntityRenderer(){
            private final VariantTrappedChestTileEntity tile = new VariantTrappedChestTileEntity();

            public void func_239207_a_(ItemStack stack, ItemCameraTransforms.TransformType transformType, MatrixStack matrix, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
                this.tile.setMaterialType(VariantTrappedChestBlock.this.getMaterialType());
                TileEntityRendererDispatcher.field_147556_a.func_228852_a_((TileEntity)this.tile, matrix, buffer, combinedLight, combinedOverlay);
            }
        };
    }
}

